import matplotlib.pyplot as plt
import seaborn as sns
import os
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.metrics import classification_report, confusion_matrix
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
from scipy import stats
import sys
sys.path.append(sys.argv[1])

import pandas as pd
import pickle
from decision_company import read_csv_file, sum_up, is_null, n_unique, create_dataframe


atp_tennis = read_csv_file(os.path.join(sys.argv[1], 'atp_tennis.csv'))

# Data Quality Report
missing_values = sum_up(is_null(atp_tennis))
unique_values = n_unique(atp_tennis, ['Tournament', 'Series', 'Court', 'Surface', 'Round'])

data_quality_report = create_dataframe({'Missing Values': missing_values, 'Unique Values': unique_values})

print(data_quality_report)
# pickle.dump(data_quality_report,open("./ref_result/data_quality_report.pkl","wb"))

import matplotlib.pyplot as plt
import seaborn as sns
import pandas as pd
import pickle
from decision_company import read_csv_file, count_unique_values, transform, generate_summary_stat, concatenate_objects, create_dataframe, generate_summary_stat, create_subplots, create_histogram_subplot, set_plot_split_title, make_xlabel, save_plot, create_scatter_plot, make_ylabel, create_bar_chart, show_plots


# Count the number of wins for each player:
player_wins = count_unique_values(atp_tennis['Winner'])

# Count the total number of matches played by each player:
player_matches = count_unique_values(atp_tennis['Player_1']) + count_unique_values(atp_tennis['Player_2'])


# Calculate win/loss ratio for each player:
win_loss_ratios = player_wins / (player_matches - player_wins)

# Add win/loss ratios to the dataset:
atp_tennis['Win_Loss_Ratio_1'] = transform(atp_tennis['Player_1'], win_loss_ratios)
atp_tennis['Win_Loss_Ratio_2'] = transform(atp_tennis['Player_2'], win_loss_ratios)


# Descriptive Statistics Table:
desc_stats = generate_summary_stat(atp_tennis[['Rank_1', 'Rank_2', 'Win_Loss_Ratio_1', 'Win_Loss_Ratio_2']])

# Combine Rank_1, Rank_2, Win_Loss_Ratio_1, and Win_Loss_Ratio_2 into single columns:
combined_ranks = concatenate_objects(atp_tennis['Rank_1'], atp_tennis['Rank_2'])
combined_win_loss_ratios = concatenate_objects(atp_tennis['Win_Loss_Ratio_1'], atp_tennis['Win_Loss_Ratio_2'])

# Create a DataFrame with combined ranks and win/loss ratios:
combined_data = create_dataframe({'Rank': combined_ranks, 'Win_Loss_Ratio': combined_win_loss_ratios})


# Descriptive Statistics Table:
desc_stats = generate_summary_stat(combined_data)


# Histogram for Player Rankings Distribution:
fig1, ax1 = create_subplots()
create_histogram_subplot(ax1, combined_ranks, bins=50, alpha=0.5)
set_plot_split_title(ax1, 'Player Rankings Distribution')
make_xlabel(ax1, 'Ranking')
save_plot('./ref_result/hist_chart.png')
# show_plots()


# Scatter Plot for Player Rankings vs Win/Loss Ratios:
fig2, ax2 = create_subplots()
create_scatter_plot(ax2, combined_data['Rank'], combined_data['Win_Loss_Ratio'], alpha=0.5)
set_plot_split_title(ax2, 'Player Rankings vs Win/Loss Ratios')
make_xlabel(ax2, 'Ranking')
make_ylabel(ax2, 'Win/Loss Ratio')
save_plot('./ref_result/scatter_chart.png')
# show_plots()


# Bar Chart for Surface Types:
fig3, ax3 = create_subplots()
surface_counts = count_unique_values(atp_tennis['Surface'])
create_bar_chart(ax3, surface_counts)
set_plot_split_title(ax3, 'Matches by Surface Type')
make_xlabel(ax3, 'Surface')
make_ylabel(ax3, 'Number of Matches')
save_plot('./ref_result/bar_chart.png')
# show_plots()

print(desc_stats)
# pickle.dump(desc_stats,open("./ref_result/desc_stats.pkl","wb"))



import numpy as np
import pandas as pd
import scipy.stats as stats
import pickle
from decision_company import read_csv_file, df_copy, dropna, get_dummies, corr, f_oneway, avg, sem, t_ppf



# Create a DataFrame with surface types, player rankings, and win/loss ratios
surface_data = df_copy(atp_tennis[['Surface', 'Rank_1', 'Rank_2', 'Win_Loss_Ratio_1', 'Win_Loss_Ratio_2']])

# Remove rows with missing or invalid data in the Win_Loss_Ratio columns
surface_data_clean = dropna(surface_data, subset_columns=['Win_Loss_Ratio_1', 'Win_Loss_Ratio_2'])

# One-hot encoding for surface types
surface_data_clean = get_dummies(surface_data_clean, columns=['Surface'], prefix='', prefix_sep='')

# Calculate the average player ranking and win/loss ratio for each match
surface_data_clean.loc[:, 'Avg_Rank'] = (surface_data_clean['Rank_1'] + surface_data_clean['Rank_2']) / 2
surface_data_clean.loc[:, 'Avg_Win_Loss_Ratio'] = (surface_data_clean['Win_Loss_Ratio_1'] + surface_data_clean['Win_Loss_Ratio_2']) / 2

# Create a Correlation Matrix
corr_matrix = corr(surface_data_clean[['Hard', 'Clay', 'Grass', 'Avg_Rank', 'Avg_Win_Loss_Ratio']])

# Perform Statistical Tests
anova_result_clean = f_oneway(surface_data_clean['Avg_Win_Loss_Ratio'][surface_data_clean['Hard'] == 1],
                              surface_data_clean['Avg_Win_Loss_Ratio'][surface_data_clean['Clay'] == 1],
                              surface_data_clean['Avg_Win_Loss_Ratio'][surface_data_clean['Grass'] == 1])

# Calculate the mean and standard error of the mean for each surface type
hard_mean = avg(surface_data_clean['Avg_Win_Loss_Ratio'][surface_data_clean['Hard'] == 1])
hard_sem = sem(surface_data_clean['Avg_Win_Loss_Ratio'][surface_data_clean['Hard'] == 1])

clay_mean = avg(surface_data_clean['Avg_Win_Loss_Ratio'][surface_data_clean['Clay'] == 1])
clay_sem = sem(surface_data_clean['Avg_Win_Loss_Ratio'][surface_data_clean['Clay'] == 1])

grass_mean = avg(surface_data_clean['Avg_Win_Loss_Ratio'][surface_data_clean['Grass'] == 1])
grass_sem = sem(surface_data_clean['Avg_Win_Loss_Ratio'][surface_data_clean['Grass'] == 1])

# Calculate the confidence intervals using the t-distribution
confidence_level = 0.95
degrees_of_freedom = len(surface_data_clean) - 1
t_critical = t_ppf((1 + confidence_level) / 2, degrees_of_freedom)

hard_ci = (hard_mean - t_critical * hard_sem, hard_mean + t_critical * hard_sem)
clay_ci = (clay_mean - t_critical * clay_sem, clay_mean + t_critical * clay_sem)
grass_ci = (grass_mean - t_critical * grass_sem, grass_mean + t_critical * grass_sem)

# Save Results
print("Correlation Matrix:\n", corr_matrix)
pickle.dump(corr_matrix,open("./ref_result/corr_matrix.pkl","wb"))
print("P-value:", anova_result_clean.pvalue)
pickle.dump(anova_result_clean.pvalue,open("./ref_result/pvalue.pkl","wb"))
print("Confidence Intervals:\n", t_critical)
pickle.dump(t_critical,open("./ref_result/t_critical.pkl","wb"))
print("Hard SurnConfidenceface:", hard_ci)
pickle.dump(hard_ci,open("./ref_result/hard_ci.pkl","wb"))
print("Clay Surface:", clay_ci)
pickle.dump(clay_ci,open("./ref_result/clay_ci.pkl","wb"))
print("Grass Surface:", grass_ci)
pickle.dump(grass_ci,open("./ref_result/grass_ci.pkl","wb"))